<?php
namespace Concrete\Core\Application;

use Concrete\Core\Foundation\Environment;
use Concrete\Core\Foundation\Serializer\JsonSerializer;
use Concrete\Core\Foundation\Service\Provider as ServiceProvider;
use Concrete\Core\Notification\Events\ServerEventNormlizer;
use Psr\Container\ContainerInterface;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\CustomNormalizer;
use Symfony\Component\Serializer\Normalizer\JsonSerializableNormalizer;

class ApplicationServiceProvider extends ServiceProvider
{
    public function register()
    {
        $singletons = array(
            'helper/concrete/asset_library' => '\Concrete\Core\Application\Service\FileManager',
            'helper/concrete/file_manager' => '\Concrete\Core\Application\Service\FileManager',
            'helper/concrete/composer' => '\Concrete\Core\Application\Service\Composer',
            'helper/concrete/dashboard' => '\Concrete\Core\Application\Service\Dashboard',
            'helper/concrete/dashboard/sitemap' => '\Concrete\Core\Application\Service\Dashboard\Sitemap',
            'helper/concrete/ui' => '\Concrete\Core\Application\Service\UserInterface',
            'helper/concrete/ui/menu' => '\Concrete\Core\Application\Service\UserInterface\Menu',
            'helper/concrete/ui/help' => '\Concrete\Core\Application\Service\UserInterface\Help',
            'helper/concrete/upgrade' => '\Concrete\Core\Application\Service\Upgrade',
            'helper/concrete/urls' => '\Concrete\Core\Application\Service\Urls',
            'helper/concrete/user' => '\Concrete\Core\Application\Service\User',
            'helper/concrete/validation' => '\Concrete\Core\Application\Service\Validation',
            'helper/rating' => '\Concrete\Attribute\Rating\Service',
            'helper/pagination' => '\Concrete\Core\Legacy\Pagination',

            'help' => '\Concrete\Core\Application\Service\UserInterface\Help',
            'help/core' => '\Concrete\Core\Application\Service\UserInterface\Help\CoreManager',
            'help/dashboard' => '\Concrete\Core\Application\Service\UserInterface\Help\DashboardManager',
            'help/block_type' => '\Concrete\Core\Application\Service\UserInterface\Help\BlockTypeManager',
            'help/panel' => '\Concrete\Core\Application\Service\UserInterface\Help\PanelManager',
        );

        $this->app->singleton('Concrete\Core\ConcreteCms\ActivityService');
        $this->app->singleton('Concrete\Core\Block\Menu\Manager');

        foreach ($singletons as $key => $value) {
            $this->app->singleton($key, $value);
        }

        $this->app->bind('error', 'Concrete\Core\Error\ErrorList\ErrorList');

        $this->app->bindShared('environment', function ($app) {
            $env = Environment::get();

            return $env;
        });

        $this->app->bind(ContainerInterface::class, function() {
            return $this->app;
        });

        /*
         * @deprecated
         */
        $this->app->singleton('helper/concrete/avatar', '\Concrete\Core\Legacy\Avatar');

        $this->app->singleton(JsonSerializer::class, function($app) {
            $serializer = new JsonSerializer([
                 new ServerEventNormlizer(),
                 new JsonSerializableNormalizer(),
                 new CustomNormalizer(),
             ], [
                 new JsonEncoder()
             ]);
            return $serializer;
        });
    }
}
