<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'concrete5/concrete5';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'anahkiasen/html-object' => '1.4.4@45bb54b91112c064d3906c207259d5c8dcba798f',
  'commerceguys/addressing' => 'v1.2.2@fb98dfc72f8a3d12fac55f69ab2477a0fbfa9860',
  'composer/package-versions-deprecated' => '1.11.99.4@b174585d1fe49ceed21928a945138948cb394600',
  'concrete5/dependency-patches' => '1.6.1@43f3a7517708c21e7bf0a047778ba6976eb66ae6',
  'concrete5/doctrine-xml' => '1.2.0@03f1209d42477070a58d29e5af15688b96c66b56',
  'concrete5/monolog-cascade' => '0.6.0@2b9836dfab90148e6ae77b62967149329d96fd7d',
  'concrete5/oauth-user-data' => 'v1.0.1@416d5fd707e0b77b06a5be6d4eb9defa4aafb5a8',
  'container-interop/container-interop' => '1.2.0@79cbf1341c22ec75643d841642dd5d6acd83bdb8',
  'dapphp/securimage' => '3.6.8@5fc5953c4ffba1eb214cc83100672f238c184ca4',
  'defuse/php-encryption' => 'v2.3.1@77880488b9954b7884c25555c2a0ea9e7053f9d2',
  'doctrine/annotations' => '1.13.2@5b668aef16090008790395c02c893b1ba13f7e08',
  'doctrine/cache' => '2.1.1@331b4d5dbaeab3827976273e9356b3b453c300ce',
  'doctrine/collections' => '1.6.8@1958a744696c6bb3bb0d28db2611dc11610e78af',
  'doctrine/common' => '3.2.1@e927fc2410c8723d053b8032e591cdff76587cdb',
  'doctrine/dbal' => '2.13.7@6e22f6012b42d7932674857989fcf184e9e9b1c3',
  'doctrine/deprecations' => 'v0.5.3@9504165960a1f83cc1480e2be1dd0a0478561314',
  'doctrine/event-manager' => '1.1.1@41370af6a30faa9dc0368c4a6814d596e81aba7f',
  'doctrine/inflector' => '2.0.4@8b7ff3e4b7de6b2c84da85637b59fd2880ecaa89',
  'doctrine/instantiator' => '1.4.0@d56bf6102915de5702778fe20f2de3b2fe570b5b',
  'doctrine/lexer' => '1.2.1@e864bbf5904cb8f5bb334f99209b48018522f042',
  'doctrine/migrations' => '2.3.5@28d92a34348fee5daeb80879e56461b2e862fc05',
  'doctrine/orm' => '2.11.0@bfed8cb6ed448f4ab1ea3fff06e4d6c44439e4ef',
  'doctrine/persistence' => '2.2.3@5e7bdbbfe9811c06e1f745d1c166647d5c47d6ee',
  'dragonmantank/cron-expression' => 'v3.3.1@be85b3f05b46c39bbc0d95f6c071ddff669510fa',
  'egulias/email-validator' => '1.2.17@19674b35a0a3456be1b96e137098d31ed386fb61',
  'enshrined/svg-sanitize' => '0.14.1@307b42066fb0b76b5119f5e1f0826e18fefabe95',
  'filp/whoops' => '2.14.5@a63e5e8f26ebbebf8ed3c5c691637325512eb0dc',
  'friendsofphp/proxy-manager-lts' => 'v1.0.5@006aa5d32f887a4db4353b13b5b5095613e0611f',
  'gettext/gettext' => 'v3.5.9@5b1d69f5889513f7ed65060ad2a662ec3b0875c7',
  'gettext/languages' => '2.9.0@ed56dd2c7f4024cc953ed180d25f02f2640e3ffa',
  'guzzlehttp/guzzle' => '6.5.5@9d4290de1cfd701f38099ef7e183b64b4b7b0c5e',
  'guzzlehttp/promises' => '1.5.1@fe752aedc9fd8fcca3fe7ad05d419d32998a06da',
  'guzzlehttp/psr7' => '1.8.3@1afdd860a2566ed3c2b0b4a3de6e23434a79ec85',
  'htmlawed/htmlawed' => '1.1.22@b270453ba016ee4c6dae585f047d1e4f3cc456a1',
  'illuminate/collections' => 'v8.69.0@05f286ec5fd2dd286e8384577047efc375c8954c',
  'illuminate/config' => 'v8.80.0@70973cbbe0cb524658b6eeaa2386dd5b71de4b02',
  'illuminate/container' => 'v8.80.0@e18f8ce24a551e086621b00c7b75d6914d2011b4',
  'illuminate/contracts' => 'v8.69.0@e76f4bce73a2a1656add24bd5210ebc4b8af49c0',
  'illuminate/filesystem' => 'v8.73.2@a7bc30dac4e27dbeb37b026f3dbaee13bd578861',
  'illuminate/macroable' => 'v8.69.0@300aa13c086f25116b5f3cde3ca54ff5c822fb05',
  'illuminate/support' => 'v8.69.0@a8851b7001530d3c11626a81449ed9b63dd10db7',
  'imagine/imagine' => '1.2.4@d2e18be6e930ca169e4f921ef73ebfc061bf55d8',
  'indigophp/hash-compat' => 'v1.1.0@43a19f42093a0cd2d11874dff9d891027fc42214',
  'jbroadway/urlify' => '1.2.3-stable@b7c142a247bd5fac2bb62ca2491bd151c4d1dee4',
  'laminas/laminas-cache' => '2.13.2@fc3255833c1c687ed2c5312e9663ef062be155c9',
  'laminas/laminas-cache-storage-adapter-memory' => '1.1.0@02c7a4a1118bbd47d1c0f0bfe1e8b140af79d2bd',
  'laminas/laminas-code' => '3.4.1@1cb8f203389ab1482bf89c0e70a04849bacd7766',
  'laminas/laminas-escaper' => '2.9.0@891ad70986729e20ed2e86355fcf93c9dc238a5f',
  'laminas/laminas-eventmanager' => '3.4.0@a93fd278c97b2d41ebbce5ba048a24e3e6f580ba',
  'laminas/laminas-feed' => '2.16.0@cbd0e10c867a1efa6594164d229d8caf4a4ae4c7',
  'laminas/laminas-i18n' => '2.13.0@b3a55d05818ed37ed18e76c103727e95e32cf591',
  'laminas/laminas-loader' => '2.8.0@d0589ec9dd48365fd95ad10d1c906efd7711c16b',
  'laminas/laminas-mail' => '2.15.1@70c3476913c74e9befd782ab665ad1b9ebac556e',
  'laminas/laminas-mime' => '2.9.1@72d21a1b4bb7086d4a4d7058c0abca180b209184',
  'laminas/laminas-servicemanager' => '3.7.0@2b0aee477fdbd3191af7c302b93dbc5fda0626f4',
  'laminas/laminas-stdlib' => '3.6.0@c53d8537f108fac3fae652677a19735db730ba46',
  'laminas/laminas-validator' => '2.15.0@270380e87904f5a1a1fba3059989d4ca157e16a9',
  'laminas/laminas-zendframework-bridge' => '1.4.0@bf180a382393e7db5c1e8d0f2ec0c4af9c724baf',
  'laravel/helpers' => 'v1.5.0@c28b0ccd799d58564c41a62395ac9511a1e72931',
  'lcobucci/jwt' => '3.4.6@3ef8657a78278dfeae7707d51747251db4176240',
  'league/csv' => '9.7.4@002f55f649e7511710dc7154ff44c7be32c8195c',
  'league/event' => '2.2.0@d2cc124cf9a3fab2bb4ff963307f60361ce4d119',
  'league/flysystem' => '1.1.9@094defdb4a7001845300334e7c1ee2335925ef99',
  'league/flysystem-cached-adapter' => '1.0.9@08ef74e9be88100807a3b92cc9048a312bf01d6f',
  'league/fractal' => '0.19.2@06dc15f6ba38f2dde2f919d3095d13b571190a7c',
  'league/mime-type-detection' => '1.8.0@b38b25d7b372e9fddb00335400467b223349fd7e',
  'league/oauth2-server' => '8.3.3@f5698a3893eda9a17bcd48636990281e7ca77b2a',
  'league/openid-connect-claims' => '1.1.0@94c25fafdb36d1ee462dc1e74f95709943c1d363',
  'league/pipeline' => '1.0.0@aa14b0e3133121f8be39e9a3b6ddd011fc5bb9a8',
  'league/tactician' => 'v1.0.3@d0339e22fd9252fb0fa53102b488d2c514483b8a',
  'league/url' => '3.3.5@1ae2c3ce29a7c5438339ff6388225844e6479da8',
  'lusitanian/oauth' => 'v0.8.11@fc11a53db4b66da555a6a11fce294f574a8374f9',
  'michelf/php-markdown' => '1.9.1@5024d623c1a057dcd2d076d25b7d270a1d0d55f3',
  'mlocati/composer-patcher' => '1.2.2@38db5a938b33dfba6ccba5f0eb11a2fba8205b52',
  'mlocati/concrete5-translation-library' => '1.7.1@877e645dafa8c488385cfdd7c48418d98b335547',
  'mlocati/ip-lib' => '1.18.0@c77bd0b1f3e3956c7e9661e75cb1f54ed67d95d2',
  'mobiledetect/mobiledetectlib' => '2.8.37@9841e3c46f5bd0739b53aed8ac677fa712943df7',
  'monolog/monolog' => '1.26.1@c6b00f05152ae2c9b04a448f99c7590beb6042f5',
  'nesbot/carbon' => '2.56.0@626ec8cbb724cd3c3400c3ed8f730545b744e3f4',
  'pagerfanta/pagerfanta' => 'v2.7.2@911f515ae80898981c07c3d098f2092e97da1a2f',
  'paragonie/constant_time_encoding' => 'v2.4.0@f34c2b11eb9d2c9318e13540a1dbc2a3afbd939c',
  'paragonie/random_compat' => 'v2.0.20@0f1f60250fccffeaf5dda91eea1c018aed1adc2a',
  'patchwork/utf8' => 'v1.3.3@e1fa4d4a57896d074c9a8d01742b688d5db4e9d5',
  'phpseclib/phpseclib' => '3.0.12@89bfb45bd8b1abc3b37e910d57f5dbd3174f40fb',
  'predis/predis' => 'v1.1.10@a2fb02d738bedadcffdbb07efa3a5e7bd57f8d6e',
  'primal/color' => '1.0.1@dca054972fd09cba33f51675878030305b85030a',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.1.1@8622567409010282b7aeebe4bb841fe98b58dcaf',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-message' => '1.0.1@f6561bf28d520154e4b0ec72be95418abe6d9363',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'psr/simple-cache' => '1.0.1@408d5eafb83c57f6365a3ca330ff23aa4a5fa39b',
  'punic/punic' => '3.7.0@6e14078c3848030a69401125b2665f8bc84ba386',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'sabre/uri' => '2.2.1@f502edffafea8d746825bd5f0b923a60fd2715ff',
  'sabre/vobject' => '4.4.1@06feff370141fd3118609f808e86d9315864bf14',
  'sabre/xml' => '2.2.3@c3b959f821c19b36952ec4a595edd695c216bfc6',
  'scssphp/scssphp' => 'v1.10.0@9699a52a862da4efb43985943afa17150155dd3d',
  'sunra/php-simple-html-dom-parser' => 'v1.5.2@75b9b1cb64502d8f8c04dc11b5906b969af247c6',
  'symfony/amqp-messenger' => 'v5.3.7@7bf38ef8c72d51163aa9048d7a8abe03be33f2b4',
  'symfony/cache' => 'v5.4.2@8aad4b69a10c5c51ab54672e78995860f5e447ec',
  'symfony/cache-contracts' => 'v2.4.0@c0446463729b89dd4fa62e9aeecc80287323615d',
  'symfony/class-loader' => 'v3.4.47@a22265a9f3511c0212bf79f54910ca5a77c0e92c',
  'symfony/config' => 'v5.3.10@ac23c2f24d5634966d665d836c3933d54347e5d4',
  'symfony/console' => 'v5.4.2@a2c6b7ced2eb7799a35375fb9022519282b5405e',
  'symfony/deprecation-contracts' => 'v2.4.0@5f38c8804a9e97d23e0c8d63341088cd8a22d627',
  'symfony/doctrine-messenger' => 'v5.3.10@971b7d5bd1c641cb8a699f4dcfd1079e2030761a',
  'symfony/error-handler' => 'v5.3.7@3bc60d0fba00ae8d1eaa9eb5ab11a2bbdd1fc321',
  'symfony/event-dispatcher' => 'v5.4.0@27d39ae126352b9fa3be5e196ccf4617897be3eb',
  'symfony/event-dispatcher-contracts' => 'v2.4.0@69fee1ad2332a7cbab3aca13591953da9cdb7a11',
  'symfony/filesystem' => 'v5.3.4@343f4fe324383ca46792cae728a3b6e2f708fb32',
  'symfony/finder' => 'v5.3.7@a10000ada1e600d109a6c7632e9ac42e8bf2fb93',
  'symfony/http-client' => 'v5.3.10@710b69ed4bc9469900ec5ae5c3807b0509bee0dc',
  'symfony/http-client-contracts' => 'v2.4.0@7e82f6084d7cae521a75ef2cb5c9457bbda785f4',
  'symfony/http-foundation' => 'v5.4.2@ce952af52877eaf3eab5d0c08cc0ea865ed37313',
  'symfony/http-kernel' => 'v5.4.2@35b7e9868953e0d1df84320bb063543369e43ef5',
  'symfony/mercure' => 'v0.4.1@e4d96d15b41ed4f86e0674d5c9ef366985bf6b1c',
  'symfony/messenger' => 'v5.4.2@c35f9937b3bde678377ec0d5879760ad007cb500',
  'symfony/options-resolver' => 'v5.3.7@4b78e55b179003a42523a362cc0e8327f7a69b5e',
  'symfony/polyfill-ctype' => 'v1.23.0@46cd95797e9df938fdd2b03693b5fca5e64b01ce',
  'symfony/polyfill-intl-grapheme' => 'v1.23.1@16880ba9c5ebe3642d1995ab866db29270b36535',
  'symfony/polyfill-intl-idn' => 'v1.23.0@65bd267525e82759e7d8c4e8ceea44f398838e65',
  'symfony/polyfill-intl-normalizer' => 'v1.23.0@8590a5f561694770bdcd3f9b5c69dde6945028e8',
  'symfony/polyfill-mbstring' => 'v1.23.1@9174a3d80210dca8daa7f31fec659150bbeabfc6',
  'symfony/polyfill-php72' => 'v1.23.0@9a142215a36a3888e30d0a9eeea9766764e96976',
  'symfony/polyfill-php73' => 'v1.23.0@fba8933c384d6476ab14fb7b8526e5287ca7e010',
  'symfony/polyfill-php80' => 'v1.23.1@1100343ed1a92e3a38f9ae122fc0eb21602547be',
  'symfony/polyfill-php81' => 'v1.23.0@e66119f3de95efc359483f810c4c3e6436279436',
  'symfony/polyfill-uuid' => 'v1.24.0@7529922412d23ac44413d0f308861d50cf68d3ee',
  'symfony/property-access' => 'v5.4.2@133c62a1be8a868134c4cced928568568d6b26f8',
  'symfony/property-info' => 'v5.3.8@39de5bed8c036f76ec0457ec52908e45d5497947',
  'symfony/psr-http-message-bridge' => 'v2.1.2@22b37c8a3f6b5d94e9cdbd88e1270d96e2f97b34',
  'symfony/redis-messenger' => 'v5.3.10@94ba9b20a7f2b28ec9e93823d7912ced0108b398',
  'symfony/routing' => 'v5.4.0@9eeae93c32ca86746e5d38f3679e9569981038b1',
  'symfony/serializer' => 'v5.4.2@2dba9731463e0bb4fa9568ce67887ed6fa08e9bc',
  'symfony/service-contracts' => 'v2.4.0@f040a30e04b57fbcc9c6cbcf4dbaa96bd318b9bb',
  'symfony/stopwatch' => 'v5.3.4@b24c6a92c6db316fee69e38c80591e080e41536c',
  'symfony/string' => 'v5.3.10@d70c35bb20bbca71fc4ab7921e3c6bda1a82a60c',
  'symfony/translation' => 'v5.3.10@6ef197aea2ac8b9cd63e0da7522b3771714035aa',
  'symfony/translation-contracts' => 'v2.4.0@95c812666f3e91db75385749fe219c5e494c7f95',
  'symfony/var-dumper' => 'v5.3.10@875432adb5f5570fff21036fd22aee244636b7d1',
  'symfony/var-exporter' => 'v5.3.8@a7604de14bcf472fe8e33f758e9e5b7bf07d3b91',
  'symfony/yaml' => 'v4.4.36@a19f7c44ba665fa9d9d415cc4493361381b93f9b',
  'tedivm/stash' => 'v0.16.0@7d42f58e4f395397d7c76d4eff55eb56aacadc34',
  'true/punycode' => 'v2.1.1@a4d0c11a36dd7f4e7cd7096076cab6d3378a071e',
  'tubalmartin/cssmin' => 'v4.1.1@3cbf557f4079d83a06f9c3ff9b957c022d7805cf',
  'voku/portable-ascii' => '1.5.6@80953678b19901e5165c56752d087fc11526017c',
  'voku/stop-words' => '2.0.1@8e63c0af20f800b1600783764e0ce19e53969f71',
  'webmozart/assert' => '1.10.0@6964c76c7804814a842473e0c8fd15bab0f18e25',
  'wikimedia/composer-merge-plugin' => 'v2.0.1@8ca2ed8ab97c8ebce6b39d9943e9909bb4f18912',
  'wikimedia/less.php' => '1.8.2@e238ad228d74b6ffd38209c799b34e9826909266',
  'concrete5/core' => 'dev-develop@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-apc' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-apcu' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-blackhole' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-dba' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-ext-mongodb' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-filesystem' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-memcache' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-memcached' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-mongodb' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-redis' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-session' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-wincache' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-xcache' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'laminas/laminas-cache-storage-adapter-zend-server' => '*@e97fc6d656dde5d02bddaf29e793f1512814764d',
  'concrete5/concrete5' => 'dev-develop@e97fc6d656dde5d02bddaf29e793f1512814764d',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
