<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'concrete5/concrete5';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'anahkiasen/html-object' => '1.4.4@45bb54b91112c064d3906c207259d5c8dcba798f',
  'commerceguys/addressing' => 'v1.2.1@311040bd78ea2ea82105dd1f17205c449ac8de47',
  'composer/package-versions-deprecated' => '1.11.99.4@b174585d1fe49ceed21928a945138948cb394600',
  'concrete5/dependency-patches' => '1.6.1@43f3a7517708c21e7bf0a047778ba6976eb66ae6',
  'concrete5/doctrine-xml' => '1.2.0@03f1209d42477070a58d29e5af15688b96c66b56',
  'concrete5/oauth-user-data' => 'v1.0.1@416d5fd707e0b77b06a5be6d4eb9defa4aafb5a8',
  'container-interop/container-interop' => '1.2.0@79cbf1341c22ec75643d841642dd5d6acd83bdb8',
  'dapphp/securimage' => '3.6.8@5fc5953c4ffba1eb214cc83100672f238c184ca4',
  'defuse/php-encryption' => 'v2.3.1@77880488b9954b7884c25555c2a0ea9e7053f9d2',
  'doctrine/annotations' => '1.13.2@5b668aef16090008790395c02c893b1ba13f7e08',
  'doctrine/cache' => '2.1.1@331b4d5dbaeab3827976273e9356b3b453c300ce',
  'doctrine/collections' => '1.6.8@1958a744696c6bb3bb0d28db2611dc11610e78af',
  'doctrine/common' => '3.2.0@6d970a11479275300b5144e9373ce5feacfa9b91',
  'doctrine/dbal' => '2.13.4@2411a55a2a628e6d8dd598388ab13474802c7b6e',
  'doctrine/deprecations' => 'v0.5.3@9504165960a1f83cc1480e2be1dd0a0478561314',
  'doctrine/event-manager' => '1.1.1@41370af6a30faa9dc0368c4a6814d596e81aba7f',
  'doctrine/inflector' => '2.0.3@9cf661f4eb38f7c881cac67c75ea9b00bf97b210',
  'doctrine/instantiator' => '1.4.0@d56bf6102915de5702778fe20f2de3b2fe570b5b',
  'doctrine/lexer' => '1.2.1@e864bbf5904cb8f5bb334f99209b48018522f042',
  'doctrine/migrations' => '2.3.4@6d87c9a0baa6a4725b4c4e1a45b2a39f53bf1859',
  'doctrine/orm' => '2.10.2@81d472f6f96b8b571cafefe8d2fef89ed9446a62',
  'doctrine/persistence' => '2.2.2@4ce4712e6dc84a156176a0fbbb11954a25c93103',
  'dragonmantank/cron-expression' => 'v3.1.0@7a8c6e56ab3ffcc538d05e8155bb42269abf1a0c',
  'egulias/email-validator' => '1.2.17@19674b35a0a3456be1b96e137098d31ed386fb61',
  'enshrined/svg-sanitize' => '0.14.1@307b42066fb0b76b5119f5e1f0826e18fefabe95',
  'filp/whoops' => '2.14.4@f056f1fe935d9ed86e698905a957334029899895',
  'friendsofphp/proxy-manager-lts' => 'v1.0.5@006aa5d32f887a4db4353b13b5b5095613e0611f',
  'gettext/gettext' => 'v3.5.9@5b1d69f5889513f7ed65060ad2a662ec3b0875c7',
  'gettext/languages' => '2.8.1@4ad818b6341e177b7c508ec4c37e18932a7b788a',
  'guzzlehttp/guzzle' => '6.5.5@9d4290de1cfd701f38099ef7e183b64b4b7b0c5e',
  'guzzlehttp/promises' => '1.4.1@8e7d04f1f6450fef59366c399cfad4b9383aa30d',
  'guzzlehttp/psr7' => '1.8.2@dc960a912984efb74d0a90222870c72c87f10c91',
  'htmlawed/htmlawed' => '1.1.22@b270453ba016ee4c6dae585f047d1e4f3cc456a1',
  'illuminate/collections' => 'v8.61.0@18fa841df912ec56849351dd6ca8928e8a98b69d',
  'illuminate/config' => 'v8.68.1@70973cbbe0cb524658b6eeaa2386dd5b71de4b02',
  'illuminate/container' => 'v8.68.1@ef73feb5216ef97ab7023cf59c0c8dbbd5505a9d',
  'illuminate/contracts' => 'v8.61.0@ab4bb4ec3b36905ccf972c84f9aaa2bdd1153913',
  'illuminate/filesystem' => 'v8.68.1@a7bc30dac4e27dbeb37b026f3dbaee13bd578861',
  'illuminate/macroable' => 'v8.61.0@300aa13c086f25116b5f3cde3ca54ff5c822fb05',
  'illuminate/support' => 'v8.61.0@b0a21c41163381dd9a5abbd68fe85ed7b4247d30',
  'imagine/imagine' => '1.2.4@d2e18be6e930ca169e4f921ef73ebfc061bf55d8',
  'indigophp/hash-compat' => 'v1.1.0@43a19f42093a0cd2d11874dff9d891027fc42214',
  'jbroadway/urlify' => '1.2.2-stable@9b227e8548f16268cef55b5eb5d659a801fa824b',
  'laminas/laminas-cache' => '2.13.0@566948e32f30881cb903ffbd0e3e20dac00cd83e',
  'laminas/laminas-cache-storage-adapter-apc' => '1.0.1@8b375d994f6e67534f6ae6e995249e706faa30c1',
  'laminas/laminas-cache-storage-adapter-apcu' => '1.1.0@e182aab739d6b03992a9915cc3c7019391a94548',
  'laminas/laminas-cache-storage-adapter-blackhole' => '1.2.1@4af1053efd81785a292c2a9442871c075700345a',
  'laminas/laminas-cache-storage-adapter-dba' => '1.0.1@ad968d3d8a0350af8e6717be58bb96e5a9e77f3b',
  'laminas/laminas-cache-storage-adapter-ext-mongodb' => '1.2.0@72f68589cc8323fa688167a4720b795dd0907f4e',
  'laminas/laminas-cache-storage-adapter-filesystem' => '1.1.1@76fc488c3fa0ad442e4e70f807305c940d1bdcbc',
  'laminas/laminas-cache-storage-adapter-memcache' => '1.1.0@1d2a74e300a0fd0b8d0e0cb4e379a173ccad0088',
  'laminas/laminas-cache-storage-adapter-memcached' => '1.2.0@d05f33e43a352b85c6d0208e9cfbf2a59f02ede3',
  'laminas/laminas-cache-storage-adapter-memory' => '1.1.0@02c7a4a1118bbd47d1c0f0bfe1e8b140af79d2bd',
  'laminas/laminas-cache-storage-adapter-mongodb' => '1.0.1@ef4aa396b55533b8eb3e1d4126c39a78a22e49a6',
  'laminas/laminas-cache-storage-adapter-redis' => '1.2.0@de8a63d4a0ef1ccead401eb7fb6d75b57fa3f9ee',
  'laminas/laminas-cache-storage-adapter-session' => '1.1.0@74a275056cfca2300eb9a67cd1d917f7066b4113',
  'laminas/laminas-cache-storage-adapter-wincache' => '1.0.1@0f54599c5d9aff11b01adadd2742097f923170ba',
  'laminas/laminas-cache-storage-adapter-xcache' => '1.0.1@24049557aa796ec7527bcc8032ed68346232b219',
  'laminas/laminas-cache-storage-adapter-zend-server' => '1.0.1@8d0b0d219a048a92472d89a5e527990f3ea2decc',
  'laminas/laminas-code' => '3.4.1@1cb8f203389ab1482bf89c0e70a04849bacd7766',
  'laminas/laminas-escaper' => '2.9.0@891ad70986729e20ed2e86355fcf93c9dc238a5f',
  'laminas/laminas-eventmanager' => '3.4.0@a93fd278c97b2d41ebbce5ba048a24e3e6f580ba',
  'laminas/laminas-feed' => '2.15.0@3ef837a12833c74b438d2c3780023c4244e0abae',
  'laminas/laminas-i18n' => '2.11.3@563b1b720ee53f2748473656a250d65911fc4462',
  'laminas/laminas-loader' => '2.8.0@d0589ec9dd48365fd95ad10d1c906efd7711c16b',
  'laminas/laminas-mail' => '2.15.1@70c3476913c74e9befd782ab665ad1b9ebac556e',
  'laminas/laminas-mime' => '2.9.1@72d21a1b4bb7086d4a4d7058c0abca180b209184',
  'laminas/laminas-servicemanager' => '3.7.0@2b0aee477fdbd3191af7c302b93dbc5fda0626f4',
  'laminas/laminas-stdlib' => '3.6.0@c53d8537f108fac3fae652677a19735db730ba46',
  'laminas/laminas-validator' => '2.15.0@270380e87904f5a1a1fba3059989d4ca157e16a9',
  'laminas/laminas-zendframework-bridge' => '1.4.0@bf180a382393e7db5c1e8d0f2ec0c4af9c724baf',
  'laravel/helpers' => 'v1.4.1@febb10d8daaf86123825de2cb87f789a3371f0ac',
  'lcobucci/jwt' => '3.4.6@3ef8657a78278dfeae7707d51747251db4176240',
  'league/csv' => '9.7.2@8544655c460fd01eed0ad258e514488d4b388645',
  'league/event' => '2.2.0@d2cc124cf9a3fab2bb4ff963307f60361ce4d119',
  'league/flysystem' => '1.1.5@18634df356bfd4119fe3d6156bdb990c414c14ea',
  'league/flysystem-cached-adapter' => '1.0.9@08ef74e9be88100807a3b92cc9048a312bf01d6f',
  'league/fractal' => '0.19.2@06dc15f6ba38f2dde2f919d3095d13b571190a7c',
  'league/mime-type-detection' => '1.7.0@3b9dff8aaf7323590c1d2e443db701eb1f9aa0d3',
  'league/oauth2-server' => '8.3.3@f5698a3893eda9a17bcd48636990281e7ca77b2a',
  'league/openid-connect-claims' => '1.1.0@94c25fafdb36d1ee462dc1e74f95709943c1d363',
  'league/pipeline' => '1.0.0@aa14b0e3133121f8be39e9a3b6ddd011fc5bb9a8',
  'league/tactician' => 'v1.0.3@d0339e22fd9252fb0fa53102b488d2c514483b8a',
  'league/url' => '3.3.5@1ae2c3ce29a7c5438339ff6388225844e6479da8',
  'lusitanian/oauth' => 'v0.8.11@fc11a53db4b66da555a6a11fce294f574a8374f9',
  'michelf/php-markdown' => '1.9.0@c83178d49e372ca967d1a8c77ae4e051b3a3c75c',
  'mlocati/composer-patcher' => '1.2.2@38db5a938b33dfba6ccba5f0eb11a2fba8205b52',
  'mlocati/concrete5-translation-library' => '1.6.0@4caccae6c1e28edbdccc619c527bd42dbedec331',
  'mlocati/ip-lib' => '1.17.0@db9552c3460d5fa19a4c8183767fe89da7752a4e',
  'mobiledetect/mobiledetectlib' => '2.8.37@9841e3c46f5bd0739b53aed8ac677fa712943df7',
  'monolog/monolog' => '1.26.1@c6b00f05152ae2c9b04a448f99c7590beb6042f5',
  'nesbot/carbon' => '2.53.1@f4655858a784988f880c1b8c7feabbf02dfdf045',
  'pagerfanta/pagerfanta' => 'v2.7.2@911f515ae80898981c07c3d098f2092e97da1a2f',
  'paragonie/constant_time_encoding' => 'v2.4.0@f34c2b11eb9d2c9318e13540a1dbc2a3afbd939c',
  'paragonie/random_compat' => 'v2.0.20@0f1f60250fccffeaf5dda91eea1c018aed1adc2a',
  'patchwork/utf8' => 'v1.3.3@e1fa4d4a57896d074c9a8d01742b688d5db4e9d5',
  'phpseclib/phpseclib' => '3.0.11@6e794226a35159eb06f355efe59a0075a16551dd',
  'predis/predis' => 'v1.1.9@c50c3393bb9f47fa012d0cdfb727a266b0818259',
  'primal/color' => '1.0.1@dca054972fd09cba33f51675878030305b85030a',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.1.1@8622567409010282b7aeebe4bb841fe98b58dcaf',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-message' => '1.0.1@f6561bf28d520154e4b0ec72be95418abe6d9363',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'psr/simple-cache' => '1.0.1@408d5eafb83c57f6365a3ca330ff23aa4a5fa39b',
  'punic/punic' => '3.6.1@046917d7bb931ab944c0995898608491820fcdf9',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'sabre/uri' => '2.2.1@f502edffafea8d746825bd5f0b923a60fd2715ff',
  'sabre/vobject' => '4.3.5@d8a0a9ae215a8acfb51afc29101c7344670b9c83',
  'sabre/xml' => '2.2.3@c3b959f821c19b36952ec4a595edd695c216bfc6',
  'scssphp/scssphp' => 'v1.8.1@5e37759a63caf54392a4b709358a39ac7425a69f',
  'sunra/php-simple-html-dom-parser' => 'v1.5.2@75b9b1cb64502d8f8c04dc11b5906b969af247c6',
  'symfony/amqp-messenger' => 'v5.3.7@7bf38ef8c72d51163aa9048d7a8abe03be33f2b4',
  'symfony/cache' => 'v5.3.10@2056f2123f47c9f63102a8b92974c362f4fba568',
  'symfony/cache-contracts' => 'v2.4.0@c0446463729b89dd4fa62e9aeecc80287323615d',
  'symfony/class-loader' => 'v3.4.47@a22265a9f3511c0212bf79f54910ca5a77c0e92c',
  'symfony/config' => 'v5.3.4@4268f3059c904c61636275182707f81645517a37',
  'symfony/console' => 'v5.3.10@d4e409d9fbcfbf71af0e5a940abb7b0b4bad0bd3',
  'symfony/deprecation-contracts' => 'v2.4.0@5f38c8804a9e97d23e0c8d63341088cd8a22d627',
  'symfony/doctrine-messenger' => 'v5.3.7@3d7d247feeaec4be4bbd22a1d06ae9343701336b',
  'symfony/error-handler' => 'v5.3.7@3bc60d0fba00ae8d1eaa9eb5ab11a2bbdd1fc321',
  'symfony/event-dispatcher' => 'v5.3.7@ce7b20d69c66a20939d8952b617506a44d102130',
  'symfony/event-dispatcher-contracts' => 'v2.4.0@69fee1ad2332a7cbab3aca13591953da9cdb7a11',
  'symfony/filesystem' => 'v5.3.4@343f4fe324383ca46792cae728a3b6e2f708fb32',
  'symfony/finder' => 'v5.3.7@a10000ada1e600d109a6c7632e9ac42e8bf2fb93',
  'symfony/http-client' => 'v5.3.7@da8638ffecefc4e8ba2bc848d7b61a408119b333',
  'symfony/http-client-contracts' => 'v2.4.0@7e82f6084d7cae521a75ef2cb5c9457bbda785f4',
  'symfony/http-foundation' => 'v5.3.10@9f34f02e8a5fdc7a56bafe011cea1ce97300e54c',
  'symfony/http-kernel' => 'v5.3.10@703e4079920468e9522b72cf47fd76ce8d795e86',
  'symfony/mercure' => 'v0.4.1@e4d96d15b41ed4f86e0674d5c9ef366985bf6b1c',
  'symfony/messenger' => 'v5.3.10@5146f9ecede00a3570f766a6c14cf494d479e038',
  'symfony/options-resolver' => 'v5.3.7@4b78e55b179003a42523a362cc0e8327f7a69b5e',
  'symfony/polyfill-ctype' => 'v1.23.0@46cd95797e9df938fdd2b03693b5fca5e64b01ce',
  'symfony/polyfill-intl-grapheme' => 'v1.23.1@16880ba9c5ebe3642d1995ab866db29270b36535',
  'symfony/polyfill-intl-idn' => 'v1.23.0@65bd267525e82759e7d8c4e8ceea44f398838e65',
  'symfony/polyfill-intl-normalizer' => 'v1.23.0@8590a5f561694770bdcd3f9b5c69dde6945028e8',
  'symfony/polyfill-mbstring' => 'v1.23.1@9174a3d80210dca8daa7f31fec659150bbeabfc6',
  'symfony/polyfill-php72' => 'v1.23.0@9a142215a36a3888e30d0a9eeea9766764e96976',
  'symfony/polyfill-php73' => 'v1.23.0@fba8933c384d6476ab14fb7b8526e5287ca7e010',
  'symfony/polyfill-php80' => 'v1.23.1@1100343ed1a92e3a38f9ae122fc0eb21602547be',
  'symfony/polyfill-php81' => 'v1.23.0@e66119f3de95efc359483f810c4c3e6436279436',
  'symfony/polyfill-uuid' => 'v1.23.0@9165effa2eb8a31bb3fa608df9d529920d21ddd9',
  'symfony/property-access' => 'v5.3.8@2fbab5f95ddb6b8e85f38a6a8a04a17c0acc4d66',
  'symfony/property-info' => 'v5.3.7@7202b6c93a07df5df83eb58e3757dffb77fc5d90',
  'symfony/psr-http-message-bridge' => 'v1.3.0@9d3e80d54d9ae747ad573cad796e8e247df7b796',
  'symfony/redis-messenger' => 'v5.3.7@ec74daf942ef7ba64f054b462964b931e01e6d3f',
  'symfony/routing' => 'v5.3.7@be865017746fe869007d94220ad3f5297951811b',
  'symfony/serializer' => 'v5.3.10@5d7f068253ac3e7c62964ebdda491b06d401059a',
  'symfony/service-contracts' => 'v2.4.0@f040a30e04b57fbcc9c6cbcf4dbaa96bd318b9bb',
  'symfony/stopwatch' => 'v5.3.4@b24c6a92c6db316fee69e38c80591e080e41536c',
  'symfony/string' => 'v5.3.7@8d224396e28d30f81969f083a58763b8b9ceb0a5',
  'symfony/translation' => 'v5.3.7@4d595a6d15fd3a2c67f6f31d14d15d3b7356d7a6',
  'symfony/translation-contracts' => 'v2.4.0@95c812666f3e91db75385749fe219c5e494c7f95',
  'symfony/var-dumper' => 'v5.3.7@3ad5af4aed07d0a0201bbcfc42658fe6c5b2fb8f',
  'symfony/var-exporter' => 'v5.3.7@2ded877ab0574d8b646f4eb3f716f8ed7ee7f392',
  'symfony/yaml' => 'v4.4.29@3abcc4db06d4e776825eaa3ed8ad924d5bc7432a',
  'tedivm/stash' => 'v0.16.0@7d42f58e4f395397d7c76d4eff55eb56aacadc34',
  'theorchard/monolog-cascade' => 'dev-master@38e1b56e1ab7db1e12782bcf62ea92d7d971e2d2',
  'true/punycode' => 'v2.1.1@a4d0c11a36dd7f4e7cd7096076cab6d3378a071e',
  'tubalmartin/cssmin' => 'v4.1.1@3cbf557f4079d83a06f9c3ff9b957c022d7805cf',
  'voku/portable-ascii' => '1.5.6@80953678b19901e5165c56752d087fc11526017c',
  'voku/stop-words' => '2.0.1@8e63c0af20f800b1600783764e0ce19e53969f71',
  'webmozart/assert' => '1.10.0@6964c76c7804814a842473e0c8fd15bab0f18e25',
  'wikimedia/composer-merge-plugin' => 'v2.0.1@8ca2ed8ab97c8ebce6b39d9943e9909bb4f18912',
  'wikimedia/less.php' => '1.8.2@e238ad228d74b6ffd38209c799b34e9826909266',
  'concrete5/core' => 'dev-master@96dee9b0226f3326ba6f31f94c3169429abeb186',
  'concrete5/concrete5' => 'dev-master@96dee9b0226f3326ba6f31f94c3169429abeb186',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
